//--------------------------------------------------------------------------------------
// File:		DescriptorFile.cpp.
// Namespace:	Global.
// Description:	
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------

#ifndef __DESCRIPTORFILE__
#include "DescriptorFile.h"
#endif //__DESCRIPTORFILE__

#ifndef __CORE__
#include "Core.h"
#endif //__CORE__


//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------

#define CLASS_NAME DescriptorFile


//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Description:	Destructor.
// Parameters:	None.
// Returns:		None.
//--------------------------------------------------------------------------------------
DescriptorFile::~DescriptorFile()
{
	// Close the file if it is open.
	close();
}

//--------------------------------------------------------------------------------------
// Description:	Open this descriptor file.
// Parameters:	The name of this descriptor file,
//				The mode/type of this descriptor file.
// Returns:		None.
//--------------------------------------------------------------------------------------
void DescriptorFile::open(std::string fileName, enum Mode mode)
{
	// Set the mode.
	self.mode = mode;

	// Calculate the open mode.
	std::ofstream::open_mode openMode = std::ofstream::out | std::ofstream::trunc;

	if (Mode_Binary == mode)
	{
		openMode |= std::ofstream::binary;
	}
	else
	{
//		openMode |= std::ofstream::text;
	}

	// Open the stream.
	self.stream.open(fileName.c_str(), openMode);
}

//--------------------------------------------------------------------------------------
// Description:	Close this file.
// Parameters:	None.
// Returns:		None.
//--------------------------------------------------------------------------------------
void DescriptorFile::close()
{
	if (self.stream.is_open())
	{
		self.stream.close();
	}
}

//--------------------------------------------------------------------------------------
// Description:	Write the specified variable to the output stream.
// Parameters:	The output stream to write to,
//				The name of the variable,
//				The value of the variable.
// Returns:		None.
//--------------------------------------------------------------------------------------
void DescriptorFile::writeInteger(std::string name, int value)
{
//	self.stream << "\t\t" << name << " " << value << std::endl;
	self.stream.write((char*)&value, sizeof(value));
}

//--------------------------------------------------------------------------------------
// Description:	Write the specified variable to the output stream.
// Parameters:	The output stream to write to,
//				The name of the variable,
//				The value of the variable.
// Returns:		None.
//--------------------------------------------------------------------------------------
void DescriptorFile::writeFloat(std::string name, float value)
{
//	self.stream << "\t\t" << name << " " << value << std::endl;
	self.stream.write((char*)&value, sizeof(value));
}

//--------------------------------------------------------------------------------------
// Description:	Write the specified variable to the output stream.
// Parameters:	The output stream to write to,
//				The name of the variable,
//				The value of the variable,
//				The maximum number of characters to write.
// Returns:		None.
//--------------------------------------------------------------------------------------
void DescriptorFile::writeString(std::string name, std::string value, int maxSize)
{
//	self.stream << "\t\t" << name << " \"" << value << "\"" << std::endl;
	char* tempString = new char [maxSize];
	::memset(tempString, 0, maxSize);
	::memcpy(tempString, value.c_str(), value.size());
	self.stream.write(tempString, maxSize);
	delete tempString;
}

//--------------------------------------------------------------------------------------
// Description:	Write the glyph structure to the specified stream.
// Parameters:	The output stream to write to,
//				The glyph structure to write to.
// Returns:		None.
//--------------------------------------------------------------------------------------
void DescriptorFile::writeGlyphDescriptor(const Doom3GlyphDescriptor& glyphDescriptor)
{
//	self.stream << "\tchar" << std::endl;
//	self.stream << "\t{" << std::endl;
	writeInteger("height", glyphDescriptor.height);
	writeInteger("top", glyphDescriptor.top);
	writeInteger("bottom", glyphDescriptor.bottom);
	writeInteger("pitch", glyphDescriptor.pitch);
	writeInteger("xSkip", glyphDescriptor.xSkip);
	writeInteger("imageWidth", glyphDescriptor.imageWidth);
	writeInteger("imageHeight", glyphDescriptor.imageHeight);
	writeFloat("s", glyphDescriptor.s);
	writeFloat("t", glyphDescriptor.t);
	writeFloat("s2", glyphDescriptor.s2);
	writeFloat("t2", glyphDescriptor.t2);
	writeInteger("glyph", glyphDescriptor.glyph);
	writeString("shaderName", glyphDescriptor.shaderName, 32);
//	self.stream << "\t}" << std::endl;
//	self.stream << std::endl;
}

//--------------------------------------------------------------------------------------
// Description:	Write the trailing header for this file.
// Parameters:	The scale of the glyphs,
//				The name of this font.
// Returns:		None.
//--------------------------------------------------------------------------------------
void DescriptorFile::writeTrailer(float glyphScale, std::string name)
{
	writeFloat("glyphScale", glyphScale);
	writeString("name", name, 64);
}
