//--------------------------------------------------------------------------------------
// File:		Font.h.
// Namespace:	Global.
// Description:	A wrapper for a FreeType font.
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

#ifndef __FONT__
#define __FONT__

//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------

#include <string>

#include <ft2build.h>
#include FT_FREETYPE_H

#ifndef __GLYPH__
#include "Glyph.h"
#endif //__GLYPH__

#ifndef __FREETYPEOBJECT__
#include "FreeTypeObject.h"
#endif //__FREETYPEOBJECT__


//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------

#define CLASS_NAME Font


//--------------------------------------------------------------------------------------
// Data Types.
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Type name:	Font.
// Description:	A wrapper for a FreeType font.
//--------------------------------------------------------------------------------------

class Font : public FreeTypeObject
{
public:

	//--------------------------------------------------------------------------------------
	// Public methods.
	//--------------------------------------------------------------------------------------

	Font(const FT_Library& freeTypeLibrary, std::string strFontFace);

	bool setSize(float size);
	int getSize() const;

	std::string getTitle() const;

	int getGlyphIndexForCharacterCode(char characterCode) const;
	Glyph* loadGlyph(int glyphIndex, Glyph::XOffsetFixType xOffsetFixType = Glyph::XOffsetFixType_None);

	bool checkXOffsets();

	int getNumCharactersWithNegativeXOffset() const;
	int getNumCharactersWithPositiveXOffset() const;

	int getXOffsetPadding() const;

	//--------------------------------------------------------------------------------------
	// Public constants.
	//--------------------------------------------------------------------------------------

	// Doom 3 supports 256 characters.
	static const int numCharactersToExport = 256;

private:

	//--------------------------------------------------------------------------------------
	// Private data.
	//--------------------------------------------------------------------------------------

	// The type face structure.
	FT_Face typeFace;

	// The current points size of the font.
	float pointSize;
	
	// The amount of left padding required on all glyphs to fix the font for Doom 3.
	int xOffsetPadding;

	// Statistics.
	int numCharactersWithNegativeOffset;
	int numCharactersWithPositiveOffset;
};


//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------


#undef CLASS_NAME


#endif //__FONT__
