//--------------------------------------------------------------------------------------
// File:		GlyphPage.h.
// Namespace:	Global.
// Description:	
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

#ifndef __GLYPHPAGE__
#define __GLYPHPAGE__

//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------

#include <string>
#include <vector>

#include <il\il_wrap.h>

#ifndef __GLYPH__
#include "Glyph.h"
#endif //__GLYPH__

#ifndef __TYPES__
#include "Types.h"
#endif //__TYPES__


//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------

#define CLASS_NAME GlyphPage


//--------------------------------------------------------------------------------------
// Data Types.
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Type name:	GlyphPage.
// Description:	
//--------------------------------------------------------------------------------------

class GlyphPage
{
public:

	//--------------------------------------------------------------------------------------
	// Public methods.
	//--------------------------------------------------------------------------------------

	GlyphPage();

	bool canAccomodateGlyph(const Glyph& glyph) const;
	int getIndexOfBestFitArea(const Glyph& glyph) const;
	Rect addGlyph(const Glyph& glyph);
	void blitToSurface(ilImage* surface, int xPosition, int yPosition) const;
	void writeToFile(std::string fileName = "");

	int getWidth() const;
	int getHeight() const;

	void setFileName(std::string fileName);
	std::string getFileName() const;

private:

	//--------------------------------------------------------------------------------------
	// Private methods.
	//--------------------------------------------------------------------------------------

	Rect getPaddedGlyphRect(const Glyph& glyph) const;

	//--------------------------------------------------------------------------------------
	// Private data.
	//--------------------------------------------------------------------------------------

	std::vector<Rect> freeRects;

	ilImage* surface;

	std::string fileName;
};


//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------


#undef CLASS_NAME


#endif //__GLYPHPAGE__
