//--------------------------------------------------------------------------------------
// File:		TypeConversions.h.
// Namespace:	Global.
// Description:	
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

#ifndef __TYPECONVERSIONS__
#define __TYPECONVERSIONS__


//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------

#include <string>


//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Data Types.
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Description:	Convert an integer value to a string.
// Parameters:	The value to convert to a string.
// Returns:		The converted value string.
//--------------------------------------------------------------------------------------
static inline std::string toString(const int& value)
{
	char tmp[32];
	::sprintf(tmp, "%d", value);
	return std::string(tmp);
}

//--------------------------------------------------------------------------------------
// Description:	Convert an integer value to a string.
// Parameters:	The value to convert to a string.
// Returns:		The converted value string.
//--------------------------------------------------------------------------------------
static inline int toInteger(const std::string& value)
{
	return ::atoi(value.c_str());
}

//--------------------------------------------------------------------------------------
// Description:	Get a string representing a character code.
// Parameters:	The character code.
// Returns:		The string representing the character code.
//--------------------------------------------------------------------------------------
static inline std::string getCharacterCodeString(int characterCode)
{
	std::string characterString = "\"";

	if (::isprint(characterCode))
	{
		characterString += (char)characterCode;
	}

	characterString += "\" (\\" + toString(characterCode) + ")";

	return characterString;
}


#endif //__TYPECONVERSIONS__
